/*
 * Decompiled with CFR 0.152.
 */
package com.itayfeder.gelato_galore.events;

import com.itayfeder.gelato_galore.init.ItemInit;
import com.itayfeder.gelato_galore.items.IceCreamItem;
import com.itayfeder.gelato_galore.items.IceCreamSandwichItem;
import com.itayfeder.gelato_galore.items.ScooperItem;
import com.itayfeder.gelato_galore.items.SyrupItem;
import com.itayfeder.gelato_galore.reload.FlavorData;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="gelato_galore", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ColorEvents {
    @SubscribeEvent
    public static void registerColorHandlers(RegisterColorHandlersEvent.Item event) {
        ColorEvents.registerItemColorHandlers(event.getItemColors());
    }

    private static void registerItemColorHandlers(ItemColors itemColors) {
        itemColors.m_92689_((stack, color) -> {
            Item patt1179$temp = stack.m_41720_();
            if (patt1179$temp instanceof IceCreamItem) {
                IceCreamItem item = (IceCreamItem)patt1179$temp;
                if (color <= 0) {
                    return -1;
                }
                FlavorData flavor = item.getFlavor(stack, color - 1);
                if (flavor == null) {
                    return -1;
                }
                return flavor.color;
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ItemInit.ICE_CREAM_ONE.get(), (ItemLike)ItemInit.ICE_CREAM_TWO.get(), (ItemLike)ItemInit.ICE_CREAM_THREE.get()});
        itemColors.m_92689_((stack, color) -> {
            Item patt1690$temp = stack.m_41720_();
            if (patt1690$temp instanceof SyrupItem) {
                SyrupItem item = (SyrupItem)patt1690$temp;
                FlavorData flavor = SyrupItem.getFilledFlavor(stack);
                if (flavor == null) {
                    return -1;
                }
                return color <= 0 ? -1 : flavor.color;
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ItemInit.SYRUP.get()});
        itemColors.m_92689_((stack, color) -> {
            Item patt2044$temp = stack.m_41720_();
            if (patt2044$temp instanceof IceCreamSandwichItem) {
                IceCreamSandwichItem item = (IceCreamSandwichItem)patt2044$temp;
                FlavorData flavor = IceCreamSandwichItem.getFilledFlavor(stack);
                if (flavor == null) {
                    return -1;
                }
                return color <= 0 ? -1 : flavor.color;
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ItemInit.ICE_CREAM_SANDWICH.get()});
        itemColors.m_92689_((stack, color) -> {
            Item patt2433$temp = stack.m_41720_();
            if (patt2433$temp instanceof ScooperItem) {
                ScooperItem item = (ScooperItem)patt2433$temp;
                FlavorData flavor = ScooperItem.getFilledFlavor(stack);
                if (flavor == null) {
                    return -1;
                }
                return color <= 0 ? -1 : flavor.color;
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ItemInit.SCOOPER.get()});
    }
}

